VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cBall"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Body As cpBody, Shape As cpCircleShape

Public Sub Construct(ByVal X As Double, ByVal Y As Double, ByVal Radius As Double, ByVal Mass As Double)

  Set Body = PhEngine.CreateBody(Mass, PhEngine.GetMomentForCircle(Mass, 0#, Radius, 0, 0))
  PhEngine.Space.AddBody Body, X, Y
  
  Set Shape = Body.CreateCircleShape(Radius, 0, 0)
  PhEngine.Space.AddShape Shape, 0.78, 0.98
  
  'now - if it does not exists yet in our global Imagelist - we add a small sprite here from an Alpha-JPG-resource
  If Not Cairo.ImageList.Exists("Basketball") Then Cairo.ImageList.AddImage "Basketball", App.Path & "\Basketball.jpg", 2 * Radius + 0.6, 2 * Radius + 0.6
End Sub

Public Sub Draw(CC As cCairoContext, Optional ByVal SimpleOutlineOnly As Boolean)
Static SrfPat As cCairoPattern, ShineSrf As cCairoSurface

  CC.Save
    CC.TranslateDrawings Shape.tC_X, Shape.tC_Y 'translate the CC to the current center of of the Shape
    CC.RotateDrawings Cairo.CalcArc(Body.Rot_Y, Body.Rot_X) 'now rotate the Coord-System (according to the current Infos in our Body)
    
    If SimpleOutlineOnly Then 'just a simpler variant, which reflects the current rotation-state too
      CC.Arc 0, 0, Shape.Radius - 0.75
      CC.LineTo 0, 0
        CC.SetLineWidth 2
        CC.SetSourceColor vbRed
      CC.Stroke
      
    Else
      'Cairo.ImageList(SomeKey) delivers a Surface-Object (in our case our stored Sprite)
      'and to be able to shift the center of such a Surface-Object (just before we render it below),
      'we need to wrap it beforehand in some lightweight-container-Object, which allows transforms
      'And such a wrapper-object is the cCairoPattern, which can be derived from any Surface by:
      Set SrfPat = Cairo.ImageList("Basketball").CreateSurfacePattern

      'now the just mentioned shift "within the Sprite-Pattern", to finally bring
      'the pattern-wrapped Sprite-center into sync with our current center of the CC
      Set SrfPat.Matrix = SrfPat.Matrix.TranslateCoords(SrfPat.Surface.Width / 2, SrfPat.Surface.Height / 2)
        CC.SetSourcePattern SrfPat
      CC.Paint

      Static ShinePat As cCairoPattern
      If ShinePat Is Nothing Then 'we create this ShinePattern only once...
        Set ShinePat = Cairo.CreateRadialPattern(0, 0, Shape.Radius * 1.8, -Shape.Radius * 0.7, Shape.Radius * 1.5, 0)
        ShinePat.AddGaussianStops_TwoColors &H111122, &HAACCFF, 0.15, 0.85
        CC.Arc 0, 0, Shape.Radius + 2
        CC.Clip
        CC.PushGroup
        CC.Arc 0, 0, Shape.Radius + 1
        CC.Fill , ShinePat
        Set ShinePat = CC.PopGroup
        CC.ResetClip
      End If
      'and here we use it (after resetting the current rotation, so that the light comes in always with the same angle)
      CC.RotateDrawings -Cairo.CalcArc(Body.Rot_Y, Body.Rot_X)
      CC.SetSourcePattern ShinePat
      CC.Paint
      
    End If
  CC.Restore
End Sub

